/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.settings.user;

import com.ibm.hwmca.fw.managed.Status;
import com.ibm.hwmca.fw.settings.user.StatusBackgroundConstants;
import java.io.Serializable;

public class DefaultStatusBackground
implements Serializable,
Cloneable {
    private Status status;
    private String colorImageName;
    private String patternImageName;
    private int rgb;
    private transient Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DefaultStatusBackground(Status status, String colorImageName, String patternImageName, int rgb) {
        Object object = this.getLock();
        synchronized (object) {
            if (!StatusBackgroundConstants.isValidColorImageName(colorImageName)) throw new IllegalArgumentException("The 'colorImageName' argument is invalid.  Arg: [" + colorImageName + "]");
            if (!StatusBackgroundConstants.isValidPatternImageName(patternImageName)) throw new IllegalArgumentException("The 'patternImageName' argument is invalid.  Arg: [" + patternImageName + "]");
            if (!StatusBackgroundConstants.isValidRgbValue(rgb)) {
                throw new IllegalArgumentException("The 'rgb' argument is invalid.  Arg: [" + rgb + "]");
            }
            this.status = status;
            this.colorImageName = colorImageName;
            this.patternImageName = patternImageName;
            this.rgb = rgb;
            return;
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public int getRgbValue() {
        return this.rgb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImageName(boolean useColor) {
        Object object = this.getLock();
        synchronized (object) {
            return useColor ? this.colorImageName : this.patternImageName;
        }
    }

    public Object clone() {
        DefaultStatusBackground clone = null;
        try {
            clone = (DefaultStatusBackground)super.clone();
            clone.status = this.status;
            clone.colorImageName = this.colorImageName;
            clone.patternImageName = this.patternImageName;
            clone.rgb = this.rgb;
        }
        catch (CloneNotSupportedException exc) {}
        return clone;
    }

    private Object getLock() {
        if (this.lock == null) {
            this.lock = new Object();
        }
        return this.lock;
    }
}

